# Prepare data for the data appendix


# create the folder if it doesn't exist

if (!dir.exists('../Data Appendix')) {
  dir.create('../Data Appendix')
}

# First, the narrow data

time_series %>% 
  select(-Dividend_yield_withzeroes) %>% 
  write.csv('../Data Appendix/Historical time series narrow.csv', row.names = F)


# Wide data (requires some formatting to give the columns distinct names)
# this writes the 'raw' data for this spreadsheet: the spreadsheet itself includes additional metadata

time_series %>% 
  ungroup() %>% 
  gather(key = "key", value = "value", -c(Dates, Broad.sector)) %>% 
  mutate(New_title = paste0(key, Broad.sector)) %>% 
  select(-Broad.sector, -key) %>% 
  spread(New_title, value) %>% 
  write.csv('../Data Appendix/Wide data raw.csv', row.names = F)

# Annual data
SSE_annual %>% 
  group_by(Year) %>% 
  summarise(Market_cap = sum(Market_cap)) %>% 
  write.csv('../Data Appendix/Raw annual data.csv', row.names = F)